/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.AttendanceTotalAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.KintaiCommonPart;
import jp.mosp.common.part.PartManager;
import jp.mosp.common.part.VariousPart;

import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.AttendanceListVo;
import jp.mosp.kintai.vo.AttendanceMenuVo;

public class AttendanceListAction extends AttendanceTotalAction {

	// R}h
	public  static final String CMD_ATTENDANCE_LIST_SHOW		= "K1010";
	private static final String CMD_ATTENDANCE_LIST_SELECT	= "K1011";
	private static final String CMD_ATTENDANCE_LIST_SEARCH	= "K1012";
	public  static final String CMD_ATTENDANCE_LIST_RE_SEARCH	= "K1013";
	public  static final String CMD_ATTENDANCE_CARD_SELECT  	= "K1014";

	/**
	 * RXgN^
	 */
	public AttendanceListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// VO̎擾
		AttendanceListVo vo;
		vo = (AttendanceListVo)getStoredVo(CommonConst.VO_ATTENDANCE_LIST);
		if (vo == null) {
			vo = new AttendanceListVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_ATTENDANCE_LIST, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// [U[擾
		getInfo(user.getUserId());
		// \
		Date current = util.getSystemDate();
		// ΑӊǗR}h
		if (getStoredVo(CommonConst.VO_EMPLOYEE_ATTENDANCE_LIST) != null) {
			// ԑJڊmF
			vo.setCmdMenuButton(vo.CMD_MENU_MAMAGE);
			vo.setCmdListButton(EmployeeAttendanceListAction.CMD_EMPLOYEE_LIST_RE_SEARCH);
			vo.setNamListButton(CommonConst.TTL_EMPLOYEE_SELECT);
		} else {
			vo.setCmdMenuButton(vo.CMD_MENU_INPUT);
			vo.setCmdListButton(vo.CMD_MENU_INPUT);
			vo.setNamListButton(CommonConst.NAM_MENU);			
		}
		// v_E擾
		vo.aryPltYear  = util.getYearArray(MospUtility.getYear (current), 2, 1);
		vo.aryPltMonth = util.getMonthArray();
		// ΑӏF@\mF
		if (isAttendanceApprovalFunction()) {
			vo.setMode(AttendanceListVo.MODE_POSSIBLE);
		} else {
			vo.setMode(AttendanceListVo.MODE_IMPOSSIBLE);
		}
		// R}h̏
		if (cmd.equals(CMD_ATTENDANCE_LIST_SHOW)) {
			// \
			// ΏێЈݒ
			vo.setSelectKCode(mKihon.getKCode());
			// Ώ۔Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
			/*						
			 *  	2009/01/20	m.yoshida	ߓΉ
			 */
			vo.setHidDay(String.valueOf(MospUtility.getDay(current)));
			// 
			searchAttendanceList(vo);
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_SELECT)) {
			// I
			// ΏێЈݒ
			vo.setSelectKCode(key1);
			// Ώ۔Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
			/*						
			 *  	2009/01/20	m.yoshida	ߓΉ
			 */
			vo.setHidDay(String.valueOf(MospUtility.getDay(current)));
			// 
			searchAttendanceList(vo);
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_SEARCH)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// 
			searchAttendanceList(vo);
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_RE_SEARCH)) {
			// Č
			session.removeAttribute(MospConst.ATT_DTO);
			AttendanceMenuVo menuVo = (AttendanceMenuVo)getStoredVo(CommonConst.VO_ATTENDANCE_MENU);
			// ΏێЈݒ
			vo.setSelectKCode(menuVo.getHidKCode());
			// Ώ۔Nݒ
			vo.setPltYear(menuVo.getHidYear());
			vo.setPltMonth(menuVo.getHidMonth());
			/*						
			 *  	2009/01/20	m.yoshida	ߓΉ
			 */
			vo.setHidDay(menuVo.getHidDay());
			// 
			searchAttendanceList(vo);
		} else if (cmd.equals(CMD_ATTENDANCE_CARD_SELECT)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// 
			searchAttendance();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * Αӈꗗ
	 * @param vo AttendanceListVoCX^X
	 * @throws Exception
	 */
	private void searchAttendanceList(
			AttendanceListVo vo
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		// ΏۊԐݒ
		Date targetMonth;
		if (vo.getHidDay().length() != 0) {
			targetMonth = util.getDate(vo.getPltYear(), vo.getPltMonth(), vo.getHidDay());
		} else {
			targetMonth = util.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		}
		// ΑӃf[^擾
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		getAttendanceListForView(vo.getSelectKCode(), targetMonth);
		// Αӏݒ
		setCalcParam();
		// Wvf[^z쐬
		makeAttendanceArray(vo.getSelectKCode(), attendanceList);
		// Wv
		totalAttendanceDaily(vo.getSelectKCode(), attendanceList);
		// l{̎擾
		HumanBasisDtoInterface mKihonDto = getBasisInfo(vo.getSelectKCode());
		// I̐ݒ
		vo.setSelectKName(mKihonDto.getSimei());
		vo.setSelectSectionName(getSectionName(mKihonDto.getSCode()));
		// FΎ蓖ݒ
		// E擾
		if (!PartManager.position(partInfo()).isApplyAttendanceAllowance(vo.getSelectKCode())) {
			aryAttendanceCompile[17][1] = "";
		}
		// Wvf[^ƃx𕪗
		String[] aryLabel 	= new String[aryAttendanceCompile.length];
		String[] aryCompile = new String[aryAttendanceCompile.length];
		for (int i = 0; i < aryAttendanceCompile.length; i++) {
			aryLabel[i] = aryAttendanceCompile[i][0];
			aryCompile[i] = aryAttendanceCompile[i][1];
		}
		// VOݒ
		vo.setFields(aryAttendance, aryCompile, aryLabel);
	}

	/**
	 * Wvf[^z쐬
	 * @param attendanceList		ΏۏoΕ냊Xg
	 * @throws Exception
	 */
	private void makeAttendanceArray(String kCode, List<MSyukkinboDto> attendanceList) throws Exception {
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		aryAttendance = new String[count][40];
		for (int i = 0; i < aryAttendance.length; i++) {
			for (int j = 0; j < aryAttendance[i].length; j++) {
				aryAttendance[i][j] = "";
			}
		}
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// tipj
			aryAttendance[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_DATE);
			// t
			aryAttendance[i][1] = String.valueOf(MospUtility.getMonth(cal.getTime()))
			+ CommonConst.SEPARATOR_DATE
			+ String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
			// j
			aryAttendance[i][2] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			String holidayName = getPublicHolidayName(cal.getTime());
			if (holidayName.length() != 0) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][16] = remark.toString();
			// cƐ\
			if (isOverTimeRequest(kCode, cal.getTime())) {
				aryAttendance[i][16] += CommonConst.NAM_OVERTIME;
			}
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					String kinmu = "";
					// o΂̏ꍇ
					if (KintaiCommonPart.isAvailableWorkType(dto)) {
						kinmu = getWorkTypeInfo(dto.getKinmu()).getShiftName();
						// oΎ
						aryAttendance[i][4 ] = dto.getSyJikoku();
						// ދΎ
						aryAttendance[i][5 ] = dto.getTaJikoku();
						// Ζ
						aryAttendance[i][6 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						// xe
						aryAttendance[i][7 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
						// x
						aryAttendance[i][8 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTiJikan()));
						// ގ
						aryAttendance[i][9 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getSoJikan()));
						// cƎ
						aryAttendance[i][10] = getHourString(util.convIntegerTimeToDoubleTime(dto.getZaJikan()));
						// xo
						aryAttendance[i][11] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKsJikan()));
						// [鎞
						aryAttendance[i][12] = getHourString(util.convIntegerTimeToDoubleTime(dto.getSnJikan()));
					} else if (KintaiCommonPart.isWeekHoliday(dto)) {
						kinmu = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
					} else {
						for (int k = 0; k < aryHolidayReason.length; k++) {
							if (aryHolidayReason[k][0].equals(dto.getKKRiyuu())) {
								kinmu = aryHolidayReason[k][1];
							}
						}
					}
					aryAttendance[i][3 ] = kinmu;
					// ꎟFA񎟏F
					String[] result = getApproval(dto.getSnRiyuu());
					aryAttendance[i][13] = result[0];
					aryAttendance[i][14] = result[1];
					// 蓖
					StringBuffer sb = new StringBuffer();
					sb.append(dto.getSyokuji());
					sb.append(CommonConst.STR_SLASH_SEPARATOR);
					sb.append(dto.getCyoku1());
					sb.append(dto.getCyoku2());
					sb.append(dto.getCyoku3());
					sb.append(CommonConst.STR_SLASH_SEPARATOR);
					sb.append(dto.getHoka1());
					sb.append(dto.getHoka2());
					sb.append(dto.getHoka3());
					sb.append(dto.getHoka4());
					sb.append(dto.getHoka5());
					aryAttendance[i][15] = sb.toString();
					// x
					if (KintaiCommonPart.isStartHalfHoliday(dto) 
							|| KintaiCommonPart.isQuitHalfHoliday(dto)
					) {
						aryAttendance[i][16] += CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					// xo
					if (KintaiCommonPart.isWorkOnHoliday(dto)) {
						aryAttendance[i][16] += CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_HALF_KANA_SPACE;		
					}
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}

	/**
	 * cƐ\f
	 * @param kCode
	 * @param targetDate
	 * @return
	 * @throws Exception
	 */
	private boolean isOverTimeRequest(String kCode, Date targetDate) throws Exception {
		if (VariousPart.chkExistDto(PartManager.overtime(partInfo())
				.getTargetOverTimeRequest(kCode, targetDate))
		) {
			return true;
		}
		return false;
	}

}
